// Autor: Frane Kurtovic

/**
 * Slozenost O(C_SUM * C * log(C_SUM))
 */
#include <iostream>
#include <algorithm>
#include <vector>

using namespace std;

typedef long long int64;
typedef pair <int64, int64> par;

struct task {
    int64 start, sleep, len;
    int count;
};

const int64 INF = (int64)1e18;
vector <par> events; // sorted

pair<bool, vector<par>::iterator> ok (const int64 x) {
    if (x < 0) return make_pair(false, events.begin());
    auto pos = lower_bound(events.begin(), events.end(), make_pair(x, INF)) - 1;
    if (pos < events.begin()) return make_pair(false, events.begin());
    if (pos->first <= x && pos->second > x) return make_pair(false, events.begin());
    return make_pair(true, pos);
}
task target;
bool good_pos (const int64 x) {
    auto res1 = ok(x);
    auto res2 = ok(x + target.len - 1);
    if (!res1.first || !res2.first) return false;
    return res1.second == res2.second;
}

void add_task(task curr) {
  int64 curr_pos = curr.start;
  for (int j = 0; j < curr.count; j++) {
    events.push_back(par(curr_pos, curr_pos + curr.len));
    curr_pos += curr.len + curr.sleep;
  }
}

int64 solve_one() {
    sort(events.begin(), events.end());
    int64 ret = INF;
    for (const auto &event : events) {
        int64 total_len = target.len + target.sleep;
        int good_cnt = 0;
        int64 start = event.second - total_len * (target.count - 1);
        for (int c = 0; c < target.count; c++) {
            if (good_pos(start)) good_cnt++;
            start += total_len;
        }
        start = event.second - total_len * (target.count - 1);
        for (int c = 0; c < target.count; c++) {
            // pomicem udesno proces za total_len
            if (good_cnt == target.count) {
                ret = min(ret, start);
                break;
            }
            if (good_pos(start)) good_cnt--;
            start += total_len;
            if (good_pos(start + total_len * (target.count - 1))) good_cnt++;
        }
    }
    return ret;
}

int main() {
    int n, m;
    cin >> n;
    for (int i = 0; i < n; i++) {
        task curr;
        cin >> curr.start >> curr.sleep >> curr.len >> curr.count;
        int64 curr_pos = curr.start;
        for (int j = 0; j < curr.count; j++) {
            events.push_back(par(curr_pos, curr_pos + curr.len));
            curr_pos += curr.len + curr.sleep;
        }
    }
    events.push_back(par(-1, 0));
    cin >> m;
    for (int i = 0; i < m; i++) {
      sort(events.begin(), events.end());
      cin >> target.sleep >> target.len >> target.count;
      target.start = solve_one();
      add_task(target);
      cout << target.start << endl;
    }
    return 0;
}
